<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

// Common path to default layout images.
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$url = GENESIS_ADMIN_IMAGES_URL . '/layouts/';

/**
 * The Layouts config. Sets the default layouts for use by Genesis.
 *
 * If child theme contains a `layouts.php` config, it will be used instead of this config.
 *
 * @since 2.8.0
 */
return [
	'content-sidebar'         => [
		'label'   => __( 'Content, Primary Sidebar', 'genesis' ),
		'img'     => $url . 'cs.gif',
		'default' => is_rtl() ? false : true,
		'type'    => [ 'site' ],
	],
	'sidebar-content'         => [
		'label'   => __( 'Primary Sidebar, Content', 'genesis' ),
		'img'     => $url . 'sc.gif',
		'default' => is_rtl() ? true : false,
		'type'    => [ 'site' ],
	],
	'content-sidebar-sidebar' => [
		'label' => __( 'Content, Primary Sidebar, Secondary Sidebar', 'genesis' ),
		'img'   => $url . 'css.gif',
		'type'  => [ 'site' ],
	],
	'sidebar-sidebar-content' => [
		'label' => __( 'Secondary Sidebar, Primary Sidebar, Content', 'genesis' ),
		'img'   => $url . 'ssc.gif',
		'type'  => [ 'site' ],
	],
	'sidebar-content-sidebar' => [
		'label' => __( 'Secondary Sidebar, Content, Primary Sidebar', 'genesis' ),
		'img'   => $url . 'scs.gif',
		'type'  => [ 'site' ],
	],
	'full-width-content'      => [
		'label' => __( 'Full Width Content', 'genesis' ),
		'img'   => $url . 'c.gif',
		'type'  => [ 'site' ],
	],
];
