<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Customizer
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Create panels, sections, and controls in the Customizer.
 *
 * @since 2.1.0
 */
class Genesis_Customizer {

	/**
	 * The $wp_customize object.
	 *
	 * @since 2.6.0
	 *
	 * @var WP_Customize_Manager
	 */
	protected $wp_customize;

	/**
	 * Constructor.
	 *
	 * @since 2.6.0
	 *
	 * @param WP_Customize_Manager $wp_customize WP Customizer Manager.
	 */
	public function __construct( WP_Customize_Manager $wp_customize ) {

		$this->wp_customize = $wp_customize;

	}

	/**
	 * Initialize registration.
	 *
	 * By leaving a hook here, it allows other plugins and child themes to also setup and register
	 * their own panels, sections, settings, and controls.
	 *
	 * The Genesis Theme Settings and Theme SEO settings are registered in lib/admin/customizer.php.
	 *
	 * @since 2.6.0
	 */
	public function init() {

		/**
		 * Fires (when hooked correctly) on `wp_customize_register`, allowing
		 * the `$genesis_customizer` object to be used to create Customizer
		 * panels, sections, and controls.
		 *
		 * @since 2.6.0
		 *
		 * @param Genesis_Customizer $this Genesis_Customizer instance.
		 */
		do_action( 'genesis_customizer', $this );

	}

	/**
	 * Register Customizer panel, sections, settings, and controls via a `$config` array.
	 *
	 * @since 2.6.0
	 *
	 * @param array $config Customizer configuration.
	 */
	public function register( array $config ) {

		foreach ( $config as $panel_name => $panel ) {

			$this->register_panel( $panel_name, $panel );

			foreach ( (array) $panel['sections'] as $section_name => $section ) {

				$this->register_section( $section_name, $section );

				foreach ( (array) $section['controls'] as $setting_key => $control ) {

					$this->register_setting( $setting_key, $control['settings'], $panel );
					$this->register_control( $setting_key, $control, $panel );

				}
			}
		}

	}

	/**
	 * Helper alias for $wp_customize->add_panel().
	 *
	 * @since 2.6.0
	 *
	 * @param string $panel_name Name of the panel.
	 * @param array  $panel      Panel properties.
	 */
	public function register_panel( $panel_name, array $panel ) {

		unset( $panel['sections'] );

		$this->wp_customize->add_panel(
			$panel_name,
			$panel
		);

	}

	/**
	 * Helper alias for $wp_customize->add_section().
	 *
	 * @since 2.6.0
	 *
	 * @param string $section_name Section name.
	 * @param array  $section      Section properties.
	 */
	public function register_section( $section_name, array $section ) {

		unset( $section['settings'] );

		$this->wp_customize->add_section(
			$section_name,
			$section
		);

	}

	/**
	 * Helper alias for $wp_customize->add_setting().
	 *
	 * @since 2.6.0
	 *
	 * @param string $setting_name Setting name.
	 * @param mixed  $setting      Setting default value.
	 * @param array  $panel        Panel properties.
	 */
	public function register_setting( $setting_name, $setting, $panel ) {

		$defaults = [
			'type' => 'option',
		];

		$setting = wp_parse_args( $setting, $defaults );

		$setting_name = isset( $panel['settings_field'] ) ? sprintf( '%s[%s]', $panel['settings_field'], $setting_name ) : $setting_name;

		$this->wp_customize->add_setting(
			$setting_name,
			$setting
		);

	}

	/**
	 * Helper alias for $wp_customize->add_control().
	 *
	 * @since 2.6.0
	 *
	 * @param string $control_name Control name.
	 * @param array  $control      Control properties.
	 * @param array  $panel        Panel properties.
	 */
	public function register_control( $control_name, array $control, $panel ) {

		$control['settings'] = sprintf( '%s[%s]', $panel['settings_field'], $control_name );

		$control_name = isset( $panel['control_prefix'] ) ? $panel['control_prefix'] . '_' . $control_name : $control_name;

		$this->wp_customize->add_control(
			$control_name,
			$control
		);

	}

}
